<?php

defined('PHPFOX') or die('Restricted access');

/**
 * Prints synchronization data to be readed by BoWoB server.
 * @return void.
 */
function bowob_server_sync()
{
  header('Cache-Control: no-cache, must-revalidate');
  header('Content-Type: text/plain; charset=utf-8');

  include(dirname(realpath(__FILE__)) . PHPFOX_DS . 'bowob_api.php');

  echo bowob_api_get_sync_data(
    Phpfox::getLib('request')->getInt('id', '-1'),
    Phpfox::getLib('request')->get('sync', ''),
    Phpfox::getLib('request')->get('name', '') == '1',
    Phpfox::getLib('request')->get('avatar', '') == '1',
    Phpfox::getLib('request')->get('friends', '') == '1'
  );
}

/**
 * Creates a synchronization record and prints record identifiers to be readed by BoWoB client.
 * @return void.
 */
function bowob_client_sync()
{
  header('Cache-Control: no-cache, must-revalidate');
  header('Content-Type: text/plain');

  include(dirname(realpath(__FILE__)) . PHPFOX_DS . 'bowob_api.php');

  echo bowob_api_new_sync(
    Phpfox::getLib('request')->get('nick', ''),
    Phpfox::getLib('request')->get('name', '') == '1',
    Phpfox::getLib('request')->get('avatar', '') == '1'
  );
}

/**
 * Redirects to login page.
 * @return void.
 */
function bowob_redirect_login()
{
  Phpfox::getLib('url')->forward(PHPFOX_CORE_FOLDER . 'index.php?do=/user/login/');
  exit();
}

/**
 * Redirects to user profile page.
 * @return void.
 */
function bowob_redirect_profile()
{
  $iUserId = Phpfox::getLib('request')->getInt('id', '-1');

  if ($iUserId > 0)
    $sLink = Phpfox::getService('user')->getLink(Phpfox::getLib('request')->getInt('id', '-1'));
  else
    $sLink = PHPFOX_CORE_FOLDER . 'index.php?do=/';

  Phpfox::getLib('url')->forward($sLink);
  exit();
}

/**
 * Gets BoWoB HTML code for show the chat.
 * @return string The HTML code.
 */
function bowob_code($app_id, $server_address)
{
  include(dirname(realpath(__FILE__)) . PHPFOX_DS . 'bowob_api.php');

  return bowob_api_get_code($app_id, $server_address);
}

/**
 * Checks if current user is logued.
 * @return boolean User is logued.
 */
function bowob_is_user_logued()
{
  return (boolean)Phpfox::getUserBy('user_id');
}

/**
 * Gets current user id.
 * @return int User id.
 */
function bowob_get_user_id()
{
  return Phpfox::getUserBy('user_id');
}

/**
 * Gets current user nick.
 * @return string User nick.
 */
function bowob_get_user_nick()
{
  return Phpfox::getUserBy('user_name');
}

/**
 * Gets current user name.
 * @return string User name.
 */
function bowob_get_user_name()
{
  return Phpfox::getUserBy('full_name');
}

/**
 * Gets current user avatar url.
 * @return string User avatar.
 */
function bowob_get_user_avatar()
{
  // Require phpFox server settings
  require(PHPFOX_DIR . 'include' . PHPFOX_DS . 'setting' . PHPFOX_DS . 'server.sett.php');
  // Require phpFox common settings
  require(PHPFOX_DIR . 'include' . PHPFOX_DS . 'setting' . PHPFOX_DS . 'common.sett.php');

  if (bowob_is_user_logued())
  {
    $sUserImage = Phpfox::getUserBy('user_image');
    if ($sUserImage)
      return sprintf($_CONF['core.url_user'].$sUserImage, "_50");
  }

  return $_CONF['core.url_static_image'].'misc/noimage_50.png';
}

/**
 * Gets current user friends.
 * @param int $id User id.
 * @param string $separator Separator between nicks.
 * @return string User friends.
 */
function bowob_get_user_friends($id, $separator)
{
  if($id <= 0)
  {
    return '';
  }

  $output = '';

  list($iTotalFriends, $aFriends) = Phpfox::getService('friend')->get('friend.user_id = ' . $id);

  foreach ($aFriends as $aFriend)
  {
    if ($aFriend)
    {
      $output .= $aFriend['user_name'] . $separator;
    }
  }

  return $output;
}

/**
 * Stores a synchronization record in database.
 * @param string $auth Record auth.
 * @param int $creation Record creation time.
 * @param int $user_id Record user id.
 * @param string $user_nick Record user nick.
 * @param string $user_name Record user name.
 * @param string $user_avatar Record user avatar.
 * @param int $user_type Record user type.
 * @return int Record id.
 */
function bowob_store_sync($auth, $creation, $user_id, $user_nick, $user_name, $user_avatar, $user_type)
{
  return Phpfox::getLib('database')->insert(TABLE_PREFIX . 'bowob', array (
                    'auth' => $auth,
                    'creation' => (int)$creation,
                    'user_id' => (int)$user_id,
                    'user_nick' => $user_nick,
                    'user_name' => $user_name,
                    'user_avatar' => $user_avatar,
                    'user_type' => $user_type,
               )
         );
}

/**
 * Extracts a synchronization record from database.
 * @param int $id Record id.
 * @param string $auth Record auth.
 * @param int $expiration Record expiration time.
 * @return array Record values.
 */
function bowob_extract_sync($id, $auth, $expiration)
{

  Phpfox::getLib('database')->delete(TABLE_PREFIX . 'bowob', 'creation < ' . (int)$expiration);

  $rs = Phpfox::getLib('database')->select('auth, user_id, user_nick, user_name, user_avatar, user_type')
               ->from(TABLE_PREFIX . 'bowob')
               ->where("id = '".(int)$id."'")
               ->execute('getRow');

  if(!$rs || $rs['auth'] != $auth)
  {
    return array();
  }
  else
  {
    Phpfox::getLib('database')->delete(TABLE_PREFIX . 'bowob', 'id = '.(int)$id);

    return array(
      'user_id' => $rs['user_id'],
      'user_nick' => $rs['user_nick'],
      'user_name' => $rs['user_name'],
      'user_avatar' => $rs['user_avatar'],
      'user_type' => $rs['user_type'],
    );
  }
}
