<?php

/**
 * bowobchat.php,v 3.0 2011/05/17 17:25:17
 * @copyright (C) Jonatan Linares
 * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
**/

defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

class plgSystemBowobchat extends JPlugin
{
  /**
   * Implementation of onAfterInitialise()
   */
  function onAfterInitialise()
  {
    if(!$this->params->get('bowob_table_created', 0))
    {
      $this->params->set('bowob_table_created', 1);

      $this->bowob_create_table();
    }
  }

  /**
   * Implementation of onAfterRender()
   */
  function onAfterRender()
  {
    global $mainframe;

    $format = JRequest::getVar('format', 'html');
    
    if($mainframe->isAdmin() || $format != 'html')
    {
      return;
    }

    $body = JResponse::getBody();
    $body = preg_replace('/(<\/body[^>]*>)/i', $this->bowob_chat_code() . '$0', $body, 1);
    JResponse::setBody($body);
  }

  /**
   * Gets BoWoB HTML code for show the chat.
   * @return void.
   */
  function bowob_chat_code()
  {
    include(JPATH_ROOT . DS . 'plugins' . DS . 'system' . DS . 'bowob_functions.php');

    return bowob_code(
      $this->params->get('bowob_app_id', ''),
      $this->params->get('bowob_server_address', '')
    );
  }

  /**
   * Creates the BoWoB table in database.
   * @return void.
   */
  function bowob_create_table()
  {
    $db =& JFactory::getDBO();

    $db->setQuery('DROP TABLE IF EXISTS ' . $db->nameQuote('#__bowob'));
    $db->query();

    $db->setQuery('
      CREATE TABLE ' . $db->nameQuote('#__bowob') . ' (
        id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
        auth VARCHAR(50) NOT NULL DEFAULT \'\',
        creation INT(10) UNSIGNED NOT NULL DEFAULT \'0\',
        user_id INT(10) UNSIGNED NOT NULL DEFAULT \'0\',
        user_nick VARCHAR(50) NOT NULL DEFAULT \'\',
        user_name VARCHAR(50) NOT NULL DEFAULT \'\',
        user_avatar VARCHAR(200) NOT NULL DEFAULT \'\',
        user_type INT(10) UNSIGNED NOT NULL DEFAULT \'0\',
        PRIMARY KEY  (id)
      ) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8'
    );
    $db->query();

    $db->setQuery('UPDATE ' . $db->nameQuote('#__plugins') . ' SET params = ' . $db->quote($this->params->toString()) . ' WHERE element = ' . $db->quote('bowobchat'));
    $db->query();
  }
}

?>
